import { useEffect, useState } from 'react';
import styles from './index.less';

interface UserInfo {
  userName: string;
  userId: string;
}

export default function IndexPage() {
  const [userInfo, setUserInfo] = useState<UserInfo>();

  useEffect(() => {
    // 异步调用 getUserAsync 接口获取用户信息
    Manycore.User.getUserAsync().then((userInfo) => setUserInfo(userInfo));
  }, []);

  return (
    <div>
      <h1 className={styles.title}>Hello {userInfo?.userName}</h1>
    </div>
  );
}
