import * as React from "react";
import * as ReactDOM from "react-dom";
import "@manycore/miniapp-sdk"; // 引入 SDK 后可在视图中异步调用 Manycore 接口

interface UserInfo {
  userName: string;
  userId: string;
}

interface State {
  userInfo: UserInfo | null;
}

class MyComponent extends React.PureComponent<{}, State> {
  state: State = {
    userInfo: null,
  };

  componentDidMount() {
    // 异步调用 getUserAsync 接口获取用户信息
    Manycore.User.getUserAsync().then((userInfo) =>
      this.setState({ userInfo })
    );
  }

  render() {
    const { userInfo } = this.state;
    return <>Hello {userInfo?.userName}</>;
  }
}

ReactDOM.render(<MyComponent />, document.getElementById("react-container")!);
